#
# Euler #10 in Elixir.
#
# Problem 10
# """
# The sum of the primes below 10 is 2 + 3 + 5 + 7 = 17.
#  
# Find the sum of all the primes below two million.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import NumberTheory

defmodule Euler10 do

  # Too slow: 3.15896s
  def euler10a() do
    primes(2_000_000) |> sum
  end

  def run_all() do
    timeit(&Euler10.euler10a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler10.euler10a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


