#
# Euler #15 in Elixir.
#
# Problem 15
# """
# Starting in the top left corner of a 2×2 grid, there are 6 routes 
# (without backtracking) to the bottom right corner.
#  
# How many routes are there through a 20×20 grid?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler

defmodule Euler15 do

  def euler15a() do
    div(21..40 |> product,  2..20 |> product)
  end
  
  def run_all() do
    timeit(&Euler15.euler15a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler15.euler15a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


