#
# Euler #16 in Elixir.
#
# Problem 16
# """
# 2^15 = 32768 and the sum of its digits is 3 + 2 + 7 + 6 + 8 = 26.
#  
# What is the sum of the digits of the number 2^1000?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler

defmodule Euler16 do

  def euler16a() do
    2**1000 |> Integer.digits |> sum
  end
  
  def run_all() do
    timeit(&Euler16.euler16a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler16.euler16a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


