#
# Euler #17 in Elixir.
#
# Problem 17
# """
# If the numbers 1 to 5 are written out in words: one, two, three, four, five, 
# then there are 3 + 3 + 5 + 4 + 4 = 19 letters used in total.
#  
# If all the numbers from 1 to 1000 (one thousand) inclusive were written out in 
# words, how many letters would be used?
# 
# NOTE: Do not count spaces or hyphens. For example, 342 (three hundred and forty-two) 
# contains 23 letters and 115 (one hundred and fifteen) contains 20 letters. The use of 
# "and" when writing out numbers is in compliance with British usage.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#


import Enum
import Euler

defmodule Euler17 do

  #
  # This is a port of my SICStus Prolog/SWI Prolog solutions
  #
  def digit(1), do: "one" 
  def digit(2), do: "two" 
  def digit(3), do: "three" 
  def digit(4), do: "four" 
  def digit(5), do: "five" 
  def digit(6), do: "six" 
  def digit(7), do: "seven" 
  def digit(8), do: "eight" 
  def digit(9), do: "nine" 

  def teens(10), do: "ten" 
  def teens(11), do: "eleven" 
  def teens(12), do: "twelve" 
  def teens(13), do: "thirteen" 
  def teens(14), do: "fourteen" 
  def teens(15), do: "fifteen" 
  def teens(16), do: "sixteen" 
  def teens(17), do: "seventeen" 
  def teens(18), do: "eighteen" 
  def teens(19), do: "nineteen" 

  def tens(20), do: "twenty" 
  def tens(30), do: "thirty" 
  def tens(40), do: "forty" 
  def tens(50), do: "fifty" 
  def tens(60), do: "sixty" 
  def tens(70), do: "seventy" 
  def tens(80), do: "eighty" 
  def tens(90), do: "ninety" 

  def hundred(100), do: "onehundred"

  def thousand(1000), do: "onethousand"

  # fix
  def spell(0), do: ""
  
  # 1..10
  def spell(n) when n > 0 and n < 10, do: [digit(n)]

  # 10..19
  def spell(n) when n > 9 and n < 20, do: [teens n]
  
  # 20..99
  def spell(n) when n >= 20 and n < 100 do
    d = 10* div(n,10)
    ten = tens d
    m = rem(n,10)
    one = if m > 0 do digit(m) else "" end
    [ten, one]
  end

  # 100..999
  def spell(n) when n >= 100 and n < 1000 do
    hundred_ = div(n,100)
    hundred1 = digit(hundred_)
    m = rem(n,100)
    ones = spell(m)
    andstr = if m > 0 do "and" else "" end
    [hundred1, "hundred", andstr, ones]
  end

  # 1000
  def spell(1000), do: ["onethousand"]

  
  def euler17a() do
    1..1000
    |> map(fn n -> spell(n) end)    
    |> Enum.join()
    |> String.length
  end
  
  def run_all() do
    timeit(&Euler17.euler17a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler17.euler17a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


