#
# Euler #20 in Elixir.
#
# Problem 20
# """
# n! means n (n 1) ... 3 2 1
#
# Find the sum of the digits in the number 100!")
#
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import NumberTheory

defmodule Euler20 do

  def euler20a() do
     factorial(100) |> Integer.digits |> sum
  end
   
  def run_all() do
    timeit(&Euler20.euler20a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler20.euler20a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


