#
# Euler #21 in Elixir.
#
# Problem 21
# """
# Let d(n) be defined as the sum of proper divisors of n (numbers less 
# than n which divide evenly into n).
# If d(a) = b and d(b) = a, where a /= b, then a and b are an amicable 
# pair and each of a and b are called amicable numbers.
#
# For example, the proper divisors of 220 are 
# 1, 2, 4, 5, 10, 11, 20, 22, 44, 55 and 110; therefore d(220) = 284. 
# The proper divisors of 284 are 1, 2, 4, 71 and 142; so d(284) = 220.
#
# Evaluate the sum of all the amicable numbers under 10000.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import NumberTheory

defmodule Euler21 do

  
  # def amicable(n)  do
  #   a = proper_divisors_sum(n)
  #   n == proper_divisors_sum(a)
  # end

  # 0.686s which is a little too slow...
  def euler21a() do
    for a <- 1..9999 do
      b = proper_divisors_sum(a)
      if a != b do
        c = proper_divisors_sum(b)
        if a == c do
          [a,b]
        else
          []
        end
      else
        []
      end
    end
    |> List.flatten
    |> Enum.uniq 
    |> sum
  end
   
  def euler21b() do
    for a <- 1..9999 do
      b = proper_divisors_sum(a)
      c = proper_divisors_sum(b)
      if a != b && a == c do [a,b] else [] end
    end
    |> List.flatten
    |> Enum.uniq 
    |> sum
  end
   
  def run_all() do
    timeit(&Euler21.euler21a/0)
    # timeit(&Euler21.euler21b/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler21.euler21a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


