#
# Euler #23 in Elixir.
#
# Problem 23
# """
# A perfect number is a number for which the sum of its proper divisors 
# is exactly equal to the number. For example, the sum of the proper divisors 
# of 28 would be 1 + 2 + 4 + 7 + 14 = 28, which means that 28 is a perfect number.
#
# A number n is called deficient if the sum of its proper divisors is less than 
# n and it is called abundant if this sum exceeds n.
#
# As 12 is the smallest abundant number, 1 + 2 + 3 + 4 + 6 = 16, the smallest number 
# that can be written as the sum of two abundant numbers is 24. By mathematical 
# analysis, it can be shown that all integers greater than 28123 can be written 
# as the sum of two abundant numbers. However, this upper limit cannot be reduced 
# any further by analysis even though it is known that the greatest number that 
# cannot be expressed as the sum of two abundant numbers is less than this limit.

# Find the sum of all the positive integers which cannot be written as the sum of 
# two abundant numbers.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#
import Enum
import Euler
import NumberTheory
  
defmodule Euler23 do

  def abundant?(n) do
    proper_divisors_sum(n) > n
  end

  # Too slow: 2.37988s, 3.67168s
  def euler23a() do
    limit = 20161
    as = 1..limit
         |> filter(fn n -> abundant?(n) end)
    res = for a <- as, b <- as, a <= b do # , not member?(as,a+b) do
             a+b
          end
          |> List.flatten
          |> uniq
          |> into(MapSet.new)
    for i <- 1..limit, not member?(res,i) do
      i
    end
    |> sum
  end
   
  def run_all() do
    timeit(&Euler23.euler23a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler23.euler23a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


