#
# Euler #24 in Elixir.
#
# Problem 24
# """
# A permutation is an ordered arrangement of objects. For example, 3124 is one 
# possible permutation of the digits 1, 2, 3 and 4. If all of the permutations are 
# listed numerically or alphabetically, we call it lexicographic order. The 
# lexicographic permutations of 0, 1 and 2 are:
#
#     012   021   102   120   201   210
#
# What is the millionth lexicographic permutation of the digits 
# 0, 1, 2, 3, 4, 5, 6, 7, 8 and 9?

# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#
import Enum
import Euler
  
defmodule Euler24 do

  # Too slow: 4.39142s 5.70678s
  def euler24a() do
    Euler.permutations([0,1,2,3,4,5,6,7,8,9])
    |> at(1_000_000-1) # Elixir is - still - 0 based :-)
    |> Enum.join
    |> String.to_integer
  end

  # Using tuple: not faster: 6.27811s 5.28394
  def euler24b() do
    Euler.permutations([0,1,2,3,4,5,6,7,8,9])
    |> List.to_tuple
    |> elem(1_000_000-1) # Elixir is - still - 0 based :-)
    |> Enum.join
    |> String.to_integer
  end


  def run_all() do
    timeit(&Euler24.euler24a/0)
    # timeit(&Euler24.euler24b/0)    
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler24.euler24a() end),
      # Task.async(fn -> Euler24.euler24b() end),      
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


