#
# Euler #29 in Elixir.
#
# Problem 29
# """
# Consider all integer combinations of a^b for 2 <= a <= 5 and 2 <= b <= 5:
#
#     2^2=4, 2^3=8, 2^4=16, 2^5=32
#     3^2=9, 3^3=27, 3^4=81, 3^5=243
#     4^2=16, 4^3=64, 4^4=256, 4^5=1024
#     5^2=25, 5^3=125, 5^4=625, 5^5=3125
#
# If they are then placed in numerical order, with any repeats removed, we get the 
# following sequence of 15 distinct terms:
#
#   4, 8, 9, 16, 25, 27, 32, 64, 81, 125, 243, 256, 625, 1024, 3125
#
# How many distinct terms are in the sequence generated by a^b for 
# 2 <= a <= 100 and 2 <= b <= 100?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler

defmodule Euler29 do

  def euler29a() do
    min = 2
    max = 100
    for a <- min..max, b <- min..max do
      a**b
    end
    |> uniq
    |> length
  end

  def run_all() do
    timeit(&Euler29.euler29a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler29.euler29a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


