#
# Euler #3 in Elixir.
#
# Problem 3
# """
# The prime factors of 13195 are 5, 7, 13 and 29.
# What is the largest prime factor of the number 600851475143 ?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import NumberTheory

defmodule Euler3 do
  
  def euler3a() do
    prime_factors(600851475143)
    |> max
  end

  def run_all() do
    timeit(&Euler3.euler3a/0)    
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler3.euler3a() end)
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


