#
# Euler #30 in Elixir.
#
# Problem 30
# """
# Surprisingly there are only three numbers that can be written 
# as the sum of fourth powers of their digits:
#
#    1634 = 1^(4) + 6^(4) + 3^(4) + 4^(4)
#    8208 = 8^(4) + 2^(4) + 0^(4) + 8^(4)
#    9474 = 9^(4) + 4^(4) + 7^(4) + 4^(4)
#
# As 1 = 1^(4) is not a sum it is not included.
#
# The sum of these numbers is 1634 + 8208 + 9474 = 19316.
#
# Find the sum of all the numbers that can be written as the sum of 
# fifth powers of their digits.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler

defmodule Euler30 do

  def euler30a() do
    for n  <- 10..6*9**5, n == (Integer.digits(n) |> map(fn i -> i**5 end) |> sum) do
      n
    end
    |> sum
  end

  def run_all() do
    timeit(&Euler30.euler30a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler30.euler30a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


