#
# Euler #31 in Elixir.
#
# Problem 31
# """
# In England the currency is made up of pound, £, and pence, p, and 
# there are eight coins in general circulation:
#
#    1p, 2p, 5p, 10p, 20p, 50p, £1 (100p) and £2 (200p).
#
# It is possible to make £2 in the following way:
#
#    1×£1 + 1×50p + 2×20p + 1×5p + 1×2p + 3×1p
#
# How many different ways can £2 be made using any number of coins?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler

defmodule Euler31 do

  #
  # Dynamic programming.
  # Port of my Picat function coins2/3 (euler31.pi) via Curry
  #
  def coins(coins, money, m) do
    len = length(coins)    
    if m == (len-1) do
      1
    else
      coins_(m,len,coins, money, 0)
    end
  end

  def coins_(i,len,_coins,_money,s0) when i >= len, do: s0
  def coins_(i,len,coins,money, s0) do
    ci = at(coins,i)
    s1 = if money - ci == 0 do 1 else 0 end
    s2 = if money - ci  > 0 do s1 + coins(coins, money-ci, i) else s1 end
    if i < len do s0 + coins_(i+1, len, coins, money, s2) else s0 + s2 end
  end


  def euler31a() do
    coins = [200,100,50,20,10,5,2,1]
    coins(coins, 200, 0)
  end

  #
  # This does not work:
  # 'Cannot allocate 9794840320 bytes of memory (of type "heap")'
  #
  # def euler31b() do
  #   r = 0..200
  #   for a <- r, b <- r, c <- r, d <- r, e <- r, f <- r, g <- r, h <- r do
  #     if b <= 100 and c <= 40 and d <= 20 and e <= 10 and f <= 4 and g <= 2 and h <= 1 and
  #     (1*a) + (2*b) + (5*c) + (10*d) + (20*e) + (50*f) + (100*g) + (200*h) == 200 do
  #       1
  #      else
  #       0
  #     end
  #   end
  #   |>IO.inspect
  #   |> sum
  # end

  
  def run_all() do
    timeit(&Euler31.euler31a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler31.euler31a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


