#
# Euler #32 in Elixir.
#
# Problem 32
# """
# We shall say that an n-digit number is pandigital if it makes use of 
# all the digits 1 to n exactly once; for example, the 5-digit number, 
# 15234, is 1 through 5 pandigital.
#
# The product 7254 is unusual, as the identity, 39 × 186 = 7254, 
# containing multiplicand, multiplier, and product is 1 through 9 
# pandigital.
#
# Find the sum of all products whose multiplicand/multiplier/product 
# identity can be written as a 1 through 9 pandigital.
# HINT: Some products can be obtained in more than one way so be sure 
# to only include it once in your sum.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import Integer

defmodule Euler32 do

  # 
  # Check is p[0..pos] * p[pos1..4] = p[5..8] for pos in 0..3
  # 
  def check_(p, pos) do
    p1 = slice(p,0..pos)   |> undigits
    p2 = slice(p,pos+1..4) |> undigits
    p3 = slice(p,5..8)     |> undigits
    if p1*p2 == p3 do p3 else 0 end
  end

  
  #
  # Check the (four) possible combinations to ge a pandigital number.
  # 
  def check(p) do
    for pos <- 0..3 do
      pr = check_(p,pos)
      if pr > 0 do pr else 0 end
    end
  end

  # 0.87621s
  def euler32a() do
    permutations(1..9 |> to_list)
    |> map(fn p -> check(p) end)
    |> List.flatten
    |> uniq
    |> sort
    |> sum
  end

  # 1.60736s
  def euler32b() do
    for  a <- 2..98, b <- (a+1)..9876 do
      t =  (Integer.to_string(a) <> Integer.to_string(b) <> Integer.to_string(a*b))
           |> String.split("", trim: true)
      if length(t) == 9 and not Enum.member?(t,"0") and length(t |> uniq) == 9 do
        a*b 
      else
        0
      end
    end
    |> uniq
    |> sum
  end
  def run_all() do
    timeit(&Euler32.euler32a/0)
    # timeit(&Euler32.euler32b/0)    
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler32.euler32a() end), 
      # Task.async(fn -> Euler32.euler32b() end),     
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


