#
# Euler #36 in Elixir.
#
# Problem 36
# """
# The decimal number, 585 = 1001001001_(2) (binary), is palindromic 
# in both bases.
#
# Find the sum of all numbers, less than one million, which are palindromic 
# in base 10 and base 2.
#
# (Please note that the palindromic number, in either base, may not 
#  include leading zeros.)
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import Integer

defmodule Euler36 do

  def pal_10_2(n) do
    palindrome?(n |> digits(10)) && palindrome?(n |> digits(2))
  end
  
  def euler36a() do
    1..1_000_000
    |> filter(&pal_10_2/1)
    |> sum
  end
  
  def run_all() do
    timeit(&Euler36.euler36a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler36.euler36a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


