#
# Euler #4 in Elixir.
#
# Problem 4
# """
# A palindromic number reads the same both ways. The largest palindrome made 
# from the product of two 2-digit numbers is 9009 = 91 × 99.
#
# Find the largest palindrome made from the product of two 3-digit numbers.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler

defmodule Euler4 do

  def euler4a() do
    # I really like that a for loop returns a value
    for a <- 100..999, b <- a..999, palindrome?(a*b |> Integer.digits) do  
      a*b
    end
    |> max
  end

  # Using :unique (slightly faster)
  def euler4b() do
    for a <- 100..999, b <- a..999, palindrome?(a*b |> Integer.digits), :unique do  
      a*b
    end
    |> max
  end

  
  def run_all() do
    # timeit(&Euler4.euler4a/0)
    timeit(&Euler4.euler4b/0)    
  end

  def run_all_parallel() do
    tasks = [
      # Task.async(fn -> Euler4.euler4a() end),
      Task.async(fn -> Euler4.euler4b() end),      
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


