#
# Euler #42 in Elixir.
#
# Problem 42
# """
# The nth term of the sequence of triangle numbers is given by, 
#     tn = 1/2*n*(n+1); 
# so the first ten triangle numbers are:
#
#   1, 3, 6, 10, 15, 21, 28, 36, 45, 55, ...
#
# By converting each letter in a word to a number corresponding to its 
# alphabetical position and adding these values we form a word value. For example, 
# the word value for SKY is 19 + 11 + 25 = 55 = t10. If the word value 
# is a triangle number then we shall call the word a triangle word.
#
# Using words.txt (right click and 'Save Link/Target As...'), a 16K text file 
# containing nearly two-thousand common English words, how many 
# are triangle words?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
# import NumberTheory

defmodule Euler42 do
  
  def tri(n), do: div((n*(n+1)),2)

  def score(word) do
    String.to_charlist(word)
    |> map(&(&1 - 64))
    |> sum
  end
  
  def euler42a() do
    tri_nums = map(1..20, &tri/1)
    File.read!("lib/euler42_words.txt")
    |> String.replace("\"","")
    |> String.split(",")
    |> map(&score/1)
    |> filter(fn n -> member?(tri_nums, n) end)
    |> count
  end

  def run_all() do
    timeit(&Euler42.euler42a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler42.euler42a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


