#
# Euler #48 in Elixir.
#
# Problem 48
# """
# The series, 1^(1) + 2^(2) + 3^(3) + ... + 10^(10) = 10405071317.
#
# Find the last ten digits of the series, 
# 1^(1) + 2^(2) + 3^(3) + ... + 1000^(1000).
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
# import NumberTheory

defmodule Euler48 do

  def euler48a() do
    1..1000
    |> map(&(&1**&1))
    |> sum |> Integer.to_string
    |> String.slice(-10..-1)
    |> String.to_integer
  end

  # This seems to be a little faster
  def euler48b() do
    for n <- 1..1000 do n**n end
    |> sum |> Integer.to_string
    |> String.slice(-10..-1)
    |> String.to_integer
  end
  
  def run_all() do
    # timeit(&Euler48.euler48a/0)
    timeit(&Euler48.euler48b/0)    
  end

  def run_all_parallel() do
    tasks = [
      # Task.async(fn -> Euler48.euler48a() end),
      Task.async(fn -> Euler48.euler48b() end),      
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


