#
# Euler #49 in Elixir.
#
# Problem 49
# """
# The arithmetic sequence, 1487, 4817, 8147, in which each of the terms 
# increases by 3330, is unusual in two ways: (i) each of the three terms are 
# prime, and, (ii) each of the 4-digit numbers are permutations of one another.
#
# There are no arithmetic sequences made up of three 1-, 2-, or 3-digit primes, 
# exhibiting this property, but there is one other 4-digit increasing sequence.
#
# What 12-digit number do you form by concatenating the three terms 
# in this sequence?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import NumberTheory

defmodule Euler49 do

  def euler49a() do
    diff = 3330
    for n <- 1001..9999//2, n != 1487 do
      if prime?(n) do
        [n2,n3] = [n + diff, n + diff*2]
        [nd,n2d,n3d] = [n,n2,n3] |> map(&Integer.digits/1)
        if prime?(n2) and prime?(n3) and
           is_permutation?(nd,n2d) and is_permutation?(nd,n3d) do
              nd ++ n2d ++ n3d 
        end
      end
    end
    |> filter(fn n -> n != nil end) |> hd
    |> Integer.undigits
  end

  def run_all() do
    timeit(&Euler49.euler49a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler49.euler49a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


