#
# Euler #6 in Elixir.
#
# Problem 6
# """
# The sum of the squares of the first ten natural numbers is,
# 1^(2) + 2^(2) + ... + 10^(2) = 385
#
# The square of the sum of the first ten natural numbers is,
# (1 + 2 + ... + 10)^(2) = 55^(2) = 3025
#
# Hence the difference between the sum of the squares of the first ten 
# natural numbers and the square of the sum is 3025 − 385 = 2640.
#
# Find the difference between the sum of the squares of the first one 
# hundred natural numbers and the square of the sum.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler

defmodule Euler6 do

  def euler6a() do
    sum(1..100)**2 - sum(map(1..100, &(&1**2)))
  end

  # Faster
  def euler6b() do
    r = 1..100
    sum(r)**2 - sum(map(r, &(&1**2)))
  end

  def run_all() do
    # timeit(&Euler6.euler6a/0)
    timeit(&Euler6.euler6b/0)    
  end

  def run_all_parallel() do
    tasks = [
      # Task.async(fn -> Euler6.euler6a() end),
      Task.async(fn -> Euler6.euler6b() end),      
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


