#
# Euler #1 in Elixir
#
# Problem 1
# """
# If we list all the natural numbers below 10 that are multiples of 3 or 5,
# we get 3, 5, 6 and 9. The sum of these multiples is 23.
# Find the sum of all the multiples of 3 or 5 below 1000.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/

import Enum
import Euler

defmodule Euler1 do

  def euler1a() do
    Enum.filter(1..999, fn x -> rem(x,3) == 0 || rem(x,5) == 0 end) |> sum
  end

  def euler1b() do
    1..999 |> Enum.filter(fn x -> rem(x,3) == 0 || rem(x,5) == 0 end) |> sum
  end

  def euler1c() do
    for i <- 1..999, rem(i,3) == 0 || rem(i,5) == 0 do i end |> Enum.sum
  end

  def euler1d() do
    1..999 |>
      Enum.reduce(0, fn i, acc ->
        # if ((rem(i,3) == 0 || rem(i,5) == 0)) do (acc + i) else acc end
        ((rem(i,3) == 0 || rem(i,5) == 0)) && (acc + i) || acc
      end)
  end

  def euler1e() do
    for i <- 1..999 do
      if ((rem(i,3) == 0 || rem(i,5) == 0)) do i else 0 end
    end |> Enum.sum
  end


  def euler1f() do
    # Variant of euler1c using "... do: i" instead of "... do i end"
    # Note: The parens around for seems to be necessary
    (for i <- 1..999, ((rem(i,3) == 0 || rem(i,5) == 0)), do: i) |> Enum.sum
  end

  def run_all() do
    # timeit(&Euler1.euler1a/0)
    # timeit(&Euler1.euler1b/0)
    timeit(&Euler1.euler1c/0)
    # timeit(&Euler1.euler1d/0)
    # timeit(&Euler1.euler1e/0)
    # timeit(&Euler1.euler1f/0)

  end

  def run_all_parallel() do
    
    tasks = [
      # Task.async(fn -> Euler1.euler1a() end),
      # Task.async(fn -> Euler1.euler1b() end),
      Task.async(fn -> Euler1.euler1c() end),
      # Task.async(fn -> Euler1.euler1d() end),
      # Task.async(fn -> Euler1.euler1e() end),
      # Task.async(fn -> Euler1.euler1f() end),
    ]

    for task <- tasks do
      Task.await(task)
    end

  end


end

# timeit(&Euler1.euler1a/0)
# timeit(&Euler1.euler1b/0)
# timeit(&Euler1.euler1c/0)
# timeit(&Euler1.euler1d/0)
# timeit(&Euler1.euler1e/0)
# timeit(&Euler1.euler1f/0)
