#
# Euler #12 in Elixir.
#
# Problem 12
# """
# The sequence of triangle numbers is generated by adding the natural numbers. 
# So the 7th triangle number would be 1 + 2 + 3 + 4 + 5 + 6 + 7 = 28. 
# The first ten terms would be:
#
#    1, 3, 6, 10, 15, 21, 28, 36, 45, 55, ...
#
# Let us list the factors of the first seven triangle numbers:
#
#   1: 1
#   3: 1,3
#   6: 1,2,3,6
#  10: 1,2,5,10
#  15: 1,3,5,15
#  21: 1,3,7,21
#  28: 1,2,4,7,14,28
#
# We can see that the 7th triangle number, 28, is the first triangle number 
# to have over five divisors.
#
# Which is the first triangle number to have over five-hundred divisors?")
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import NumberTheory

defmodule Euler12 do

  def tri(n) do
    div(n*(n+1),2)
  end

  # A little too slow:0.43649
  def euler12a() do
    tri(
         ( Stream.iterate(5,&(&1+1))
         |> take_while(fn a -> num_divisors(tri(a)) <= 500 end)
         |> List.last
         ) + 1
    )
  end
  
  
  def run_all() do
    timeit(&Euler12.euler12a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler12.euler12a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


