#
# Euler #19 in Elixir.
#
# Problem 19
# """
# You are given the following information, but you may prefer 
# to do some research for yourself.
#
# * 1 Jan 1900 was a Monday.
# * Thirty days has September,
#   April, June and November.
#   All the rest have thirty-one,
#   Saving February alone,
#   Which has twenty-eight, rain or shine.
#   And on leap years, twenty-nine.
# * A leap year occurs on any year evenly divisible by 4, but not 
#   on a century unless it is divisible by 400.
#  
# How many Sundays fell on the first of the month during the 
# twentieth century (1 Jan 1901 to 31 Dec 2000)?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#


import Enum
import Euler

defmodule Euler19 do

  def euler19a() do
    for year <- 1901..2000, month <- 1..12 do
      y = year |> format_num
      m = month |> format_num
      date = Date.from_iso8601!(y <> "-" <> m <> "-01")
      if Date.day_of_week(date) == 7 do 1 else 0 end
    end
    |> sum
  end
   
  def run_all() do
    timeit(&Euler19.euler19a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler19.euler19a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


