#
# Euler #22 in Elixir.
#
# Problem 22
# """
# Using names.txt (right click and 'Save Link/Target As...'), a 46K 
# text file containing over five-thousand first names, begin by sorting 
# it into alphabetical order. Then working out the alphabetical value 
# for each name, multiply this value by its alphabetical position in the 
# list to obtain a name score.
#
# For example, when the list is sorted into alphabetical order, COLIN, 
# which is worth 3 + 15 + 12 + 9 + 14 = 53, is the 938th name in 
# the list. So, COLIN would obtain a score of 938 53 = 49714.
#
# What is the total of all the name scores in the file?")
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler

defmodule Euler22 do

  def string_sum(string), do: string_sum(string |> String.to_charlist, 0)
  def string_sum([], acc), do: acc
  def string_sum([c | rest], acc) do
    string_sum(rest, acc + (c - ?A + 1))
  end
  
  def euler22a() do
    file = "lib/names.txt"
    sorted = File.read!(file)
             |> String.replace(~r{\"},"")
             |> String.split(",")
             |> sort
    zip(1..length(sorted),sorted)
    |> map(fn {i, s} -> string_sum(s |> String.to_charlist,0) * i end)
    |> sum

  end

  # With Enum.with_index. Neater
  def euler22b() do
    file = "lib/names.txt"
    File.read!(file)
    |> String.replace(~r{\"},"")
    |> String.split(",")
    |> sort
    |> with_index(1)
    |> map(fn {s,i} -> string_sum(s |> String.to_charlist,0) * i end)
    |> sum
  end
   
  def run_all() do
    # timeit(&Euler22.euler22a/0)
    timeit(&Euler22.euler22b/0)    
  end

  def run_all_parallel() do
    tasks = [
      # Task.async(fn -> Euler22.euler22a() end),      
      Task.async(fn -> Euler22.euler22b() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


