#
# Euler #28 in Elixir.
#
# Problem 28
# """
# Starting with the number 1 and moving to the right in a clockwise 
# direction a 5 by 5 spiral is formed as follows:
#
#    21 22 23 24 25
#    20  7  8  9 10
#    19  6  1  2 11
#    18  5  4  3 12
#    17 16 15 14 13
#
# It can be verified that the sum of the numbers on the diagonals is 101.
#
# What is the sum of the numbers on the diagonals in a 1001 by 1001 spiral formed in
# the same way?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler

defmodule Euler28 do

  def euler28a() do
    1 + (for n <- 3..1001//2 do 4*n**2 - 6*n + 6 end |> sum)
  end

  def run_all() do
    timeit(&Euler28.euler28a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler28.euler28a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


