#
# Euler #33 in Elixir.
#
# Problem 33
# """
# The fraction 49/98 is a curious fraction, as an inexperienced mathematician in 
# attempting to simplify it may incorrectly believe that 49/98 = 4/8, which is correct, 
# is obtained by cancelling the 9s.
#
# We shall consider fractions like, 30/50 = 3/5, to be trivial examples.
#
# There are exactly four non-trivial examples of this type of fraction, less than 
# one in value, and containing two digits in the numerator and denominator.
#
# If the product of these four fractions is given in its lowest common terms, find 
# the value of the denominator.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler

defmodule Euler33 do

  def calc(y,z), do: 9.0*y*z/(10.0*y-z)  
  def check(x,y,z), do: :math.floor(x) == 1.0*x && (y/z) < 1.0 && x < 10.0
  
  def euler33a() do
    for y <- 1..9, z <- y..9, check(calc(y,z),y,z)  do
      y / z
    end
    |> reduce(1,fn x, acc -> acc*(1/x) end)
  end

  def run_all() do
    timeit(&Euler33.euler33a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler33.euler33a() end), 
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


