#
# Euler #34 in Elixir.
#
# Problem 34
# """
# 145 is a curious number, as 1! + 4! + 5! = 1 + 24 + 120 = 145.
#
# Find the sum of all numbers which are equal to the sum of the 
# factorial of their digits.
#
# Note: as 1! = 1 and 2! = 2 are not sums they are not included.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler

defmodule Euler34 do

  def check(n), do: n == Integer.digits(n) |> map(&NumberTheory.factorial/1) |> sum
  
  def euler34a() do
    10..100_000
    |> filter(&check/1)
    |> sum
  end

  def run_all() do
    timeit(&Euler34.euler34a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler34.euler34a() end), 
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


