#
# Euler #37 in Elixir.
#
# Problem 37
# """
# The number 3797 has an interesting property. Being prime itself, it is possible to 
# continuously remove digits from left to right, and remain prime at each stage: 
# 3797, 797, 97, and 7. Similarly we can work from right to left: 3797, 379, 37, and 3.
#
# Find the sum of the only eleven primes that are both truncatable from left to right 
# and right to left.
#
# NOTE: 2, 3, 5, and 7 are not considered to be truncatable primes.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import NumberTheory

defmodule Euler37 do


  
  def truncatable_prime?(n) do
    for i <- 1..nlen(n)-1 do
      prime?(rem(n,10**i)) && prime?(div(n,10**i))
    end
    |> all?
  end
  
  def e37a(_n,lst) when length(lst) == 11,  do: lst
  def e37a(n,lst) do
    if prime?(n) and truncatable_prime?(n) do      
      e37a(n+2,[n |lst])
    else
      e37a(n+2,lst)      
    end
  end
  
  def euler37a() do
    e37a(11,[])
    |> sum
  end
  
  def run_all() do
    timeit(&Euler37.euler37a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler37.euler37a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


