#
# Euler #38 in Elixir.
#
# Problem 38
# """
# Take the number 192 and multiply it by each of 1, 2, and 3:
#
#     192 × 1 = 192
#     192 × 2 = 384
#     192 × 3 = 576
#
# By concatenating each product we get the 1 to 9 pandigital, 
# 192384576. We will call 192384576 the concatenated product of 192 
# and (1,2,3)
#
# The same can be achieved by starting with 9 and multiplying by 
# 1, 2, 3, 4, and 5, giving the pandigital, 918273645, which is the 
# concatenated product of 9 and (1,2,3,4,5).
#
# What is the largest 1 to 9 pandigital 9-digit number that can be 
# formed as the concatenated product of an integer with 
# (1,2, ... , n) where n > 1?

# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
# import NumberTheory

defmodule Euler38 do

  def pandigital_1_9?(ns) do
    length(ns) == 9 && (ns == ns |> uniq) && not member?(ns,0)
  end
  
  def euler38a() do
    for n <- [9876] ++ (9875..9 |> to_list) do
      scan(1..5,[],fn i,acc -> acc ++ (n*i |> Integer.digits) end)
      |> filter(fn ls -> pandigital_1_9?(ls) end)
    end
    |> filter(fn ls -> ls != [] end)
    |> map(fn ls -> hd(ls) |> Integer.undigits  end)
    |> max
  end
  
  def run_all() do
    timeit(&Euler38.euler38a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler38.euler38a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


