#
# Euler #39 in Elixir.
#
# Problem 39
# """
# If p is the perimeter of a right angle triangle with integral length sides, 
# {a,b,c}, there are exactly three solutions for p = 120.
#
# {20,48,52}, {24,45,51}, {30,40,50}
#
# For which value of p <= 1000, is the number of solutions maximised?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
# import NumberTheory

defmodule Euler39 do

  def euler39a() do
    for a <- 1..500,
        b <- a..500,
        c <- b..500,
        t = a+b+c, t <= 1000,
        a**2 + b**2 == c**2  do
      t
    end
    |> frequencies
    |> max_by(fn {_n,t} -> t end)
    |> elem(0)
  end
  
  def run_all() do
    timeit(&Euler39.euler39a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler39.euler39a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


