#
# Euler #40 in Elixir.
#
# Problem 40
# """
# An irrational decimal fraction is created by concatenating the positive integers:
#
# 0.123456789101112131415161718192021...
#
# It can be seen that the 12th digit of the fractional part is 1.
#
# If dn represents the nth digit of the fractional part, find the 
# value of the following expression.
#
# d1 × d10 × d100 × d1000 × d10000 × d100000 × d1000000
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
# import NumberTheory

defmodule Euler40 do

  def euler40a() do
    x = 1..210000
        |> map(&Integer.to_string/1)
        |> join("")
    map(0..5,fn n -> String.at(x,10**n-1) end)
    |> map(&String.to_integer/1)
    |> product
  end

  # A variant using constants (d) instead of 10**n-1
  # Seems to be a little slower...
  def euler40b() do
    d =  [1,10,100,1000,10000,100000,1000000]
    x = 1..210000
        |> map(&Integer.to_string/1)
        |> join("")
    map(d,fn n -> String.at(x,n-1) end)
    |> map(&String.to_integer/1)
    |> product
  end
  
  def run_all() do
    timeit(&Euler40.euler40a/0)
    # timeit(&Euler40.euler40b/0)    
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler40.euler40a() end),
      # Task.async(fn -> Euler40.euler40b() end),      
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


