#
# Euler #41 in Elixir.
#
# Problem 41
# """
# We shall say that an n-digit number is pandigital if it makes use of all 
# the digits 1 to n exactly once. For example, 2143 is a 4-digit pandigital 
# and is also prime.
#
# What is the largest n-digit pandigital prime that exists?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import NumberTheory

defmodule Euler41 do
  
  def euler41a() do
    for n <- 2..9 do
      permutations(1..n |> to_list)
      |> map(&Integer.undigits/1)
      |> filter(&prime?/1)
    end
    |> List.flatten
    |> max
  end

  # It should work with a drop_while/2 but
  # I cannot wrap my brain around that now (f*ck cancer treatment!)
  # THIS IS NOT CORRECT!
  # def euler41b() do
  #   drop_while(9..2,
  #              fn n -> 
  #                IO.inspect(n)
  #                permutations(1..n |> to_list)
  #                |> map(&Integer.undigits/1)
  #                |> filter(&prime?/1)
  #                |> length == 0
  #     end)
  #   |> IO.inspect
  # end

  def run_all() do
    timeit(&Euler41.euler41a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler41.euler41a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


