#
# Euler #44 in Elixir.
#
# Problem 44
# """
# Pentagonal numbers are generated by the formula, P(n)=n(3n−1)/2. 
# The first ten pentagonal numbers are:
#
#    1, 5, 12, 22, 35, 51, 70, 92, 117, 145, ...
#
# It can be seen that P(4) + P(7) = 22 + 70 = 92 = P(8). However, 
# their difference,  70 − 22 = 48, is not pentagonal.
#
# Find the pair of pentagonal numbers, P(j) and P(k), for which their sum 
# and difference is pentagonal and D = |P(k) − P(j)| is minimised; what 
# is the value of D?  
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
# import NumberTheory

defmodule Euler44 do

  def pent(n), do: div(n*(3*n-1),2)
  
  def euler44a() do
    ps = map(1..2500,&pent/1)
         |> map(fn n -> {n,1} end) |> into(%{})
    ks = Map.keys(ps)
    for a <- ks, b <- ks, a < b, Map.has_key?(ps,a+b), Map.has_key?(ps,abs(a-b)) do
      abs(a-b)
    end
    |> min
  end

  def run_all() do
    timeit(&Euler44.euler44a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler44.euler44a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


