#
# Euler #45 in Elixir.
#
# Problem 45
# """
# Triangle, pentagonal, and hexagonal numbers are generated by the following formulae:
#
# Triangle 	  	Tn=n(n+1)/2 	  	1, 3, 6, 10, 15, ...
# Pentagonal 	  	Pn=n(3n−1)/2 	  	1, 5, 12, 22, 35, ...
# Hexagonal 	  	Hn=n(2n−1) 	  	1, 6, 15, 28, 45, ...
#
# It can be verified that T(285) = P(165) = H(143) = 40755.
#
# Find the next triangle number that is also pentagonal and hexagonal.
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

# import Enum
import Euler
# import NumberTheory

defmodule Euler45 do

  def tri(n), do: div(n*(n+1),2)
  def pent(n), do: div(n*(3*n-1),2)
  def hex(n), do: n*(2*n-1)

  def e45a(p,t,h) do
    pp = pent(p)
    tt = tri(t)
    hh = hex(h)
    if pp == tt && tt == hh do
      pp
    else
      t2 = t + 1
      tt2 = tri(t2)
      p2 = if tt2 > pp           do p + 1 else p end
      h2 = if pp > hh or tt > hh do h + 1 else h end
      e45a(p2,t2,h2)
    end
  end
  
  def euler45a() do
    t = 285+1
    p = 165+1
    h = 143+1
    e45a(p,t,h)  
  end

  # Brute force
  # def euler45a() do
  #   Stream.iterate(285,&(&1+1))
  #   |> drop_while(fn n -> tri(n) != pent(n) || tri(n) != hex(n) || pent(n) != hex(n) end)
  #   |> IO.inspect      
  # end
  
  def run_all() do
    timeit(&Euler45.euler45a/0)
    # timeit(&Euler45.euler45b/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler45.euler45a() end),
      # Task.async(fn -> Euler45.euler45b() end),      
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


