#
# Euler #46 in Elixir.
#
# Problem 46
# """
# It was proposed by Christian Goldbach that every odd composite number can be 
# written as the sum of a prime and twice a square.
#
#   9 = 7 + 2×1^2
#  15 = 7 + 2×2^2
#  21 = 3 + 2×3^2
#  25 = 7 + 2×3^2
#  27 = 19 + 2×2^2
#  33 = 31 + 2×1^2
#
# It turns out that the conjecture was false.
#
# What is the smallest odd composite that cannot be written as the 
# sum of a prime and twice a square?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

# import Enum
import Euler
import NumberTheory

defmodule Euler46 do

  def check(i,j) do
    cond do
      j > :math.sqrt(i/2)     -> true
      prime?(abs( i - 2*j*j)) -> false
      true                    -> check(i,j+1)
  end
    
  end
  
  def e46a(n) do
    if (not prime?(n)) and check(n,1) do
      n
    else
      e46a(n+2)
    end
  end
  
  def euler46a() do
    e46a(3)
  end
  
  def run_all() do
    timeit(&Euler46.euler46a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler46.euler46a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


