#
# Euler #47 in Elixir.
#
# Problem 47
# """
# The first two consecutive numbers to have two distinct prime factors are:
#
#   14 = 2 x 7
#   15 = 3 x 5
#
# The first three consecutive numbers to have three distinct 
# prime factors are:
#
#   644 = 2^2 x 7 x 23
#   645 = 3 x 5 x 43
#   646 = 2 x 17 x 19.
#
# Find the first four consecutive integers to have four distinct primes 
# factors. What is the first of these numbers?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import NumberTheory

defmodule Euler47 do

  def num_prime_factors(n) do
    prime_factors(n)
    |> uniq
    |> count
  end


  # # 0.71952s 0.69773s
  def e47a([4,4,4,4],n), do: n
  def e47a([_a,b,c,d],n) do
    i4 = n+4
    if prime?(i4) do
      e47a([b,c,d,1],n+1)
    else
      e = num_prime_factors(i4)
      e47a([b,c,d,e],n+1)        
    end    
  end

  def euler47a() do
    e47a([1,1,1,1],1)
  end
  
  def run_all() do
    timeit(&Euler47.euler47a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler47.euler47a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


