#
# Euler #5 in Elixir.
#
# Problem 5
# """
# 2520 is the smallest number that can be divided by each of the numbers 
# from 1 to 10 without any remainder.
#
# What is the smallest number that is evenly divisible by all of the numbers 
# from 1 to 20?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import NumberTheory

defmodule Euler5 do

  def euler5a() do
    reduce(2..20,1,&lcm/2)
  end

  # Brute force, just for comparison: 50.78679s, 42.0496s
  def euler5b() do
    (
      Stream.iterate(1,&(&1+1))
      |> take_while(fn n -> any?(2..20, fn i -> rem(n,i) != 0 end) && n end)
      |> max  # using List.last crashes with heap allocation error
    ) + 1

  end
  
  def run_all() do
    timeit(&Euler5.euler5a/0)
    # timeit(&Euler5.euler5a/0) # Too slow
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler5.euler5a() end),
      # Task.async(fn -> Euler5.euler5b() end),      
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


