#
# Euler #50 in Elixir.
#
# Problem 50
# """
# The prime 41, can be written as the sum of six consecutive primes:
# 41 = 2 + 3 + 5 + 7 + 11 + 13
#
# This is the longest sum of consecutive primes that adds to a prime 
# below one-hundred.
#
# The longest sum of consecutive primes below one-thousand that adds to a prime, 
# contains 21 terms, and is equal to 953.
#
# Which prime, below one-million, can be written as the sum of the most 
# consecutive primes?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import NumberTheory

defmodule Euler50 do

  # Too slow: 2.50947s 2.45079s
  def euler50a() do
    ps = primes(1000000)
    for len <- [550] ++ (549..21 |> to_list), offset <- 1..549,
                    pp = slice(ps, offset+1, offset+len) |> sum,
                    pp < 1000000,
                    prime?(pp) do
        pp
    end
    |> hd
  end

  def run_all() do
    timeit(&Euler50.euler50a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler50.euler50a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


