#
# Euler #7 in Elixir.
#
# Problem 7
# """
# By listing the first six prime numbers: 2, 3, 5, 7, 11, and 13, we can see 
# that the 6^(th) prime is 13.
#
# What is the 10001^(st) prime number?
# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

import Enum
import Euler
import NumberTheory

defmodule Euler7 do

  def euler7a() do
    nprimes(10001) |> max 
  end

  def run_all() do
    timeit(&Euler7.euler7a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler7.euler7a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


