#
# Euler #9 in Elixir.
#
# Problem 9
# """
# A Pythagorean triplet is a set of three natural numbers, a  b  c, for which,
# a^2 + b^2 = c^2
#
# For example, 3^2 + 4^2 = 9 + 16 = 25 = 5^2.
#
# There exists exactly one Pythagorean triplet for which a + b + c = 1000.
# Find the product abc.

# """
#
# This Elixir program was created by Hakan Kjellerstrand, hakank@gmail.com
# See also my Elixir page: http://www.hakank.org/elixir/
#

# import Enum
import Euler

defmodule Euler9 do

  def euler9a() do
    for c <- 1..500, b <- 1..c, a <- 1..b, a + b + c == 1000 and a**2 + b**2 - c**2 == 0 do
      a*b*c
    end
    |> List.first
  end

  def run_all() do
    timeit(&Euler9.euler9a/0)
  end

  def run_all_parallel() do
    tasks = [
      Task.async(fn -> Euler9.euler9a() end),
    ]

    for task <- tasks do
      Task.await(task)
    end
  end
  
end


