import JaCoP.fz.*;

/**
 * 
 * Original comment:
 *
 * The class is used to run FlatZinc programs
 *
 * @author Krzysztof Kuchcinski
 * @version 2.4
 * 
 *
 * This was changed by Hakan Kjellerstrand (hakank@bonetmail.com)
 * to be able to test the Nonogram repository.
 * Also see
 *   - My JaCoP page: http://www.hakank.org/JaCoP/
 *   - My MiniZinc page: http://www.hakank.org/minizinc/
 *
 */
public class JaCoPFznTest {

    //
    // hakank:
    // Generate the .fzn files with:
    // foreach_file 'mzn2fzn -G jacop --data $f -o $f.fzn nonogram_create_automaton2.mzn' '*.dzn'  
    //
    // This list was generated by 
    // ls -1 *.dzn.fzn | perl -nle 'chomp; print "\"$_\","'
    //
    String[] models = {
"nonogram_p200.dzn.fzn",
"nonogram_jacop_data000.dzn.fzn",
"nonogram_jacop_data001.dzn.fzn",
"nonogram_jacop_data002.dzn.fzn",
"nonogram_jacop_data003.dzn.fzn",
"nonogram_jacop_data004.dzn.fzn",
"nonogram_jacop_data005.dzn.fzn",
"nonogram_jacop_data006.dzn.fzn",
"nonogram_jacop_data007.dzn.fzn",
"nonogram_jacop_data008.dzn.fzn",
"nonogram_jacop_data009.dzn.fzn",
"nonogram_jacop_data010.dzn.fzn",
"nonogram_jacop_data011.dzn.fzn",
"nonogram_jacop_data012.dzn.fzn",
"nonogram_jacop_data013.dzn.fzn",
"nonogram_jacop_data014.dzn.fzn",
"nonogram_jacop_data015.dzn.fzn",
"nonogram_jacop_data016.dzn.fzn",
"nonogram_jacop_data017.dzn.fzn",
"nonogram_jacop_data018.dzn.fzn",
"nonogram_jacop_data019.dzn.fzn",
"nonogram_jacop_data020.dzn.fzn",
"nonogram_jacop_data021.dzn.fzn",
"nonogram_jacop_data022.dzn.fzn",
"nonogram_jacop_data023.dzn.fzn",
"nonogram_jacop_data024.dzn.fzn",
"nonogram_jacop_data025.dzn.fzn",
"nonogram_jacop_data026.dzn.fzn",
"nonogram_jacop_data027.dzn.fzn",
"nonogram_jacop_data028.dzn.fzn",
"nonogram_jacop_data029.dzn.fzn",
"nonogram_jacop_data030.dzn.fzn",
"nonogram_jacop_data031.dzn.fzn",
"nonogram_jacop_data032.dzn.fzn",
"nonogram_jacop_data033.dzn.fzn",
"nonogram_jacop_data034.dzn.fzn",
"nonogram_jacop_data035.dzn.fzn",
"nonogram_jacop_data036.dzn.fzn",
"nonogram_jacop_data037.dzn.fzn",
"nonogram_jacop_data038.dzn.fzn",
"nonogram_jacop_data039.dzn.fzn",
"nonogram_jacop_data040.dzn.fzn",
"nonogram_jacop_data041.dzn.fzn",
"nonogram_jacop_data042.dzn.fzn",
"nonogram_jacop_data043.dzn.fzn",
"nonogram_jacop_data044.dzn.fzn",
"nonogram_jacop_data045.dzn.fzn",
"nonogram_jacop_data046.dzn.fzn",
"nonogram_jacop_data047.dzn.fzn",
"nonogram_jacop_data048.dzn.fzn",
"nonogram_jacop_data049.dzn.fzn",
"nonogram_jacop_data050.dzn.fzn",
"nonogram_jacop_data051.dzn.fzn",
"nonogram_jacop_data052.dzn.fzn",
"nonogram_jacop_data053.dzn.fzn",
"nonogram_jacop_data054.dzn.fzn",
"nonogram_jacop_data055.dzn.fzn",
"nonogram_jacop_data056.dzn.fzn",
"nonogram_jacop_data057.dzn.fzn",
"nonogram_jacop_data058.dzn.fzn",
"nonogram_jacop_data059.dzn.fzn",
"nonogram_jacop_data060.dzn.fzn",
"nonogram_jacop_data061.dzn.fzn",
"nonogram_jacop_data062.dzn.fzn",
"nonogram_jacop_data063.dzn.fzn",
"nonogram_jacop_data064.dzn.fzn",
"nonogram_jacop_data065.dzn.fzn",
"nonogram_jacop_data066.dzn.fzn",
"nonogram_jacop_data067.dzn.fzn",
"nonogram_jacop_data068.dzn.fzn",
"nonogram_jacop_data069.dzn.fzn",
"nonogram_jacop_data070.dzn.fzn",
"nonogram_jacop_data071.dzn.fzn",
"nonogram_jacop_data072.dzn.fzn",
"nonogram_jacop_data073.dzn.fzn",
"nonogram_jacop_data074.dzn.fzn",
"nonogram_jacop_data075.dzn.fzn",
"nonogram_jacop_data076.dzn.fzn",
"nonogram_jacop_data077.dzn.fzn",
"nonogram_jacop_data078.dzn.fzn",
"nonogram_jacop_data079.dzn.fzn",
"nonogram_jacop_data080.dzn.fzn",
"nonogram_jacop_data081.dzn.fzn",
"nonogram_jacop_data082.dzn.fzn",
// "nonogram_jacop_data083.dzn.fzn", // skips this for -a
"nonogram_jacop_data084.dzn.fzn",
"nonogram_jacop_data085.dzn.fzn",
"nonogram_jacop_data086.dzn.fzn",
"nonogram_jacop_data087.dzn.fzn",
"nonogram_jacop_data088.dzn.fzn",
"nonogram_jacop_data089.dzn.fzn",
"nonogram_jacop_data090.dzn.fzn",
"nonogram_jacop_data091.dzn.fzn",
"nonogram_jacop_data092.dzn.fzn",
"nonogram_jacop_data093.dzn.fzn",
"nonogram_jacop_data094.dzn.fzn",
"nonogram_jacop_data095.dzn.fzn",
"nonogram_jacop_data096.dzn.fzn",
"nonogram_jacop_data097.dzn.fzn",
"nonogram_jacop_data098.dzn.fzn",
"nonogram_jacop_data099.dzn.fzn",
"nonogram_jacop_data100.dzn.fzn",
"nonogram_jacop_data101.dzn.fzn",
"nonogram_jacop_data102.dzn.fzn",
"nonogram_jacop_data103.dzn.fzn",
"nonogram_jacop_data104.dzn.fzn",
"nonogram_jacop_data105.dzn.fzn",
"nonogram_jacop_data106.dzn.fzn",
"nonogram_jacop_data107.dzn.fzn",
"nonogram_jacop_data108.dzn.fzn",
"nonogram_jacop_data109.dzn.fzn",
"nonogram_jacop_data110.dzn.fzn",
"nonogram_jacop_data111.dzn.fzn",
"nonogram_jacop_data112.dzn.fzn",
"nonogram_jacop_data113.dzn.fzn",
"nonogram_jacop_data114.dzn.fzn",
"nonogram_jacop_data115.dzn.fzn",
"nonogram_jacop_data116.dzn.fzn",
"nonogram_jacop_data117.dzn.fzn",
"nonogram_jacop_data118.dzn.fzn",
"nonogram_jacop_data119.dzn.fzn",
"nonogram_jacop_data120.dzn.fzn",
"nonogram_jacop_data121.dzn.fzn",
"nonogram_jacop_data122.dzn.fzn",
"nonogram_jacop_data123.dzn.fzn",
"nonogram_jacop_data124.dzn.fzn",
"nonogram_jacop_data125.dzn.fzn",
"nonogram_jacop_data126.dzn.fzn",
"nonogram_jacop_data127.dzn.fzn",
"nonogram_jacop_data128.dzn.fzn",
"nonogram_jacop_data129.dzn.fzn",
"nonogram_jacop_data130.dzn.fzn",
"nonogram_jacop_data131.dzn.fzn",
"nonogram_jacop_data132.dzn.fzn",
"nonogram_jacop_data133.dzn.fzn",
"nonogram_jacop_data134.dzn.fzn",
"nonogram_jacop_data135.dzn.fzn",
"nonogram_jacop_data136.dzn.fzn",
"nonogram_jacop_data137.dzn.fzn",
"nonogram_jacop_data138.dzn.fzn",
"nonogram_jacop_data139.dzn.fzn",
"nonogram_jacop_data140.dzn.fzn",
"nonogram_jacop_data141.dzn.fzn",
"nonogram_jacop_data142.dzn.fzn",
"nonogram_jacop_data143.dzn.fzn",
"nonogram_jacop_data144.dzn.fzn",
"nonogram_jacop_data145.dzn.fzn",
"nonogram_jacop_data146.dzn.fzn",
"nonogram_jacop_data147.dzn.fzn",
"nonogram_jacop_data148.dzn.fzn",
"nonogram_jacop_data149.dzn.fzn",
"nonogram_jacop_data150.dzn.fzn"
};

    public static void main (String args[]) {
      JaCoPFznTest run = new JaCoPFznTest();
      run.examples();
    }

    JaCoPFznTest() {}

    void examples() {
	Fz2jacop fz = new Fz2jacop();

	try {

	    for (String m : models) {
                System.out.println("Tests model " + m);
		Thread tread = java.lang.Thread.currentThread();
		java.lang.management.ThreadMXBean b = java.lang.management.ManagementFactory.getThreadMXBean();

		long startCPU = b.getThreadCpuTime(tread.getId());
		long startUser = b.getThreadUserTime(tread.getId());

                // Show statistics, require 2 solutions
                // hakank:
                // fz.main(new String[] {"-s", "-n", "2", m});
                // Show statistics, and all solutions
                // Note: Skip #83 since it has a lot of solutions.
                fz.main(new String[] {"-s", "-a", m});

// 		System.out.println( "ThreadCpuTime = " + 
// 				    (b.getThreadCpuTime(tread.getId()) - startCPU)/(long)1e+6 + "ms");
// 		System.out.println( "ThreadUserTime = " + 
// 				    (b.getThreadUserTime(tread.getId()) - startUser)/(long)1e+6 + "ms" );
		System.out.printf("CPU time = %5.3fs%n", (float)(((float)b.getThreadCpuTime(tread.getId()) - startCPU)/1e+9));

	    }
	}
	catch (Exception e) {
	    System.out.println("Exception " + e.getMessage() );
	}
    }
}

